//*************************************************************************************************
//
//	Description:
//		PostProcessingFilterPass.fx - Full screen post processing filter
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Alastair Murray
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		AMurray		    05/12/2007  0.1           Created (Moved out of HDRMethods_Combine.fx)
//	<TABLE>
//
//*************************************************************************************************

#include "stddefs.fxh"

texture SceneTexture : TEXTURE;
sampler SceneInput : SAMPLER = sampler_state
{
	FX_SAMPLERSTATE_LINEAR_TEXTURE
	Texture = < SceneTexture >;
	AddressU  = Clamp;
	AddressV  = Clamp;
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = None;
};

#include "PostProcessingFilters.fxh"

//------------------------------------------------------------------
//
// Vertex shader
//

struct VSINPUT
{
	float3 position : POSITION;								// Texture coords as a vertex position
	float2 texCoord : TEXCOORD0;
};

struct VSOUTPUT
{
	float4 position : POSITION;
	float2 texCoord : TEXCOORD0;
};



VSOUTPUT PostProcVS( VSINPUT _input )
{
	VSOUTPUT output;

	// Just pass through the texture values to the pixel shader
	output.position = float4( _input.position.xyz, 1.0f );
	output.texCoord = _input.texCoord;

	return output;
}



//
// Pixel shaders
//

struct PSINPUT
{
	float2 texCoord : TEXCOORD0;
};

COLOUR_OUTPUT_TYPE PostProcPS( PSINPUT _input ) : COLOR0
{
#ifdef USE_ALPHA_BLEND_ZERO_SRCCOLOR
	float4 c = 1.0f;	// we don't need to sample the scene for this filter
#else
	float4 c = tex2D( SceneInput, _input.texCoord );
#endif

	c = DoSimplePostProcessingEffect( c.rgb, _input.texCoord );

	return c;
}


technique PostProcessingFilter
{
	pass Pass0
	{
		ZEnable = 0;
		ZWriteEnable = false;
		AlphaTestEnable = false;
		// NOTE: AlphaBlendEnable state is set by code
#ifdef USE_ALPHA_BLEND_ZERO_SRCCOLOR
	#if defined (_PS3_)
		BlendEquation=int(FuncAdd);
		BlendFunc=int2(Zero, SrcColor);
	#else
		SrcBlend = ZERO;
		DestBlend = SRCCOLOR;
		BlendOp = ADD;
	#endif
#endif
#ifdef _PS3_
		VertexShader = compile sce_vp_rsx PostProcVS();
		PixelShader = compile sce_fp_rsx PostProcPS();
#else		
		VertexShader = compile vs_3_0 PostProcVS();
		PixelShader = compile ps_3_0 PostProcPS();
#endif
	}
}
